<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: livekit_sip.proto

namespace Livekit;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A SIP Participant is a singular SIP session connected to a LiveKit room via
 * a SIP Trunk into a SIP DispatchRule
 *
 * Generated from protobuf message <code>livekit.CreateSIPParticipantRequest</code>
 */
class CreateSIPParticipantRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * What SIP Trunk should be used to dial the user
     *
     * Generated from protobuf field <code>string sip_trunk_id = 1;</code>
     */
    protected $sip_trunk_id = '';
    /**
     * Generated from protobuf field <code>.livekit.SIPOutboundConfig trunk = 20;</code>
     */
    protected $trunk = null;
    /**
     * What number should be dialed via SIP
     *
     * Generated from protobuf field <code>string sip_call_to = 2;</code>
     */
    protected $sip_call_to = '';
    /**
     * Optional SIP From number to use. If empty, trunk number is used.
     *
     * Generated from protobuf field <code>string sip_number = 15;</code>
     */
    protected $sip_number = '';
    /**
     * What LiveKit room should this participant be connected too
     *
     * Generated from protobuf field <code>string room_name = 3;</code>
     */
    protected $room_name = '';
    /**
     * Optional identity of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_identity = 4;</code>
     */
    protected $participant_identity = '';
    /**
     * Optional name of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_name = 7;</code>
     */
    protected $participant_name = '';
    /**
     * Optional user-defined metadata. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>string participant_metadata = 8;</code>
     */
    protected $participant_metadata = '';
    /**
     * Optional user-defined attributes. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>map<string, string> participant_attributes = 9;</code>
     */
    private $participant_attributes;
    /**
     * Optionally send following DTMF digits (extension codes) when making a call.
     * Character 'w' can be used to add a 0.5 sec delay.
     *
     * Generated from protobuf field <code>string dtmf = 5;</code>
     */
    protected $dtmf = '';
    /**
     * Optionally play dialtone in the room as an audible indicator for existing participants. The `play_ringtone` option is deprectated but has the same effect.
     *
     * Generated from protobuf field <code>bool play_ringtone = 6 [deprecated = true];</code>
     * @deprecated
     */
    protected $play_ringtone = false;
    /**
     * Generated from protobuf field <code>bool play_dialtone = 13;</code>
     */
    protected $play_dialtone = false;
    /**
     * By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     * If true, a random value for identity will be used and numbers will be omitted from attributes.
     *
     * Generated from protobuf field <code>bool hide_phone_number = 10;</code>
     */
    protected $hide_phone_number = false;
    /**
     * These headers are sent as-is and may help identify this call as coming from LiveKit for the other SIP endpoint.
     *
     * Generated from protobuf field <code>map<string, string> headers = 16;</code>
     */
    private $headers;
    /**
     * Map SIP headers from 200 OK to sip.h.* participant attributes automatically.
     * When the names of required headers is known, using headers_to_attributes is strongly recommended.
     * When mapping 200 OK headers to follow-up request headers with attributes_to_headers map,
     * lowercase header names should be used, for example: sip.h.x-custom-header.
     *
     * Generated from protobuf field <code>.livekit.SIPHeaderOptions include_headers = 17;</code>
     */
    protected $include_headers = 0;
    /**
     * Max time for the callee to answer the call.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ringing_timeout = 11;</code>
     */
    protected $ringing_timeout = null;
    /**
     * Max call duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_call_duration = 12;</code>
     */
    protected $max_call_duration = null;
    /**
     * Enable voice isolation for the callee.
     *
     * Generated from protobuf field <code>bool krisp_enabled = 14;</code>
     */
    protected $krisp_enabled = false;
    /**
     * Generated from protobuf field <code>.livekit.SIPMediaEncryption media_encryption = 18;</code>
     */
    protected $media_encryption = 0;
    /**
     * Wait for the answer for the call before returning.
     *
     * Generated from protobuf field <code>bool wait_until_answered = 19;</code>
     */
    protected $wait_until_answered = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $sip_trunk_id
     *           What SIP Trunk should be used to dial the user
     *     @type \Livekit\SIPOutboundConfig $trunk
     *     @type string $sip_call_to
     *           What number should be dialed via SIP
     *     @type string $sip_number
     *           Optional SIP From number to use. If empty, trunk number is used.
     *     @type string $room_name
     *           What LiveKit room should this participant be connected too
     *     @type string $participant_identity
     *           Optional identity of the participant in LiveKit room
     *     @type string $participant_name
     *           Optional name of the participant in LiveKit room
     *     @type string $participant_metadata
     *           Optional user-defined metadata. Will be attached to a created Participant in the room.
     *     @type array|\Google\Protobuf\Internal\MapField $participant_attributes
     *           Optional user-defined attributes. Will be attached to a created Participant in the room.
     *     @type string $dtmf
     *           Optionally send following DTMF digits (extension codes) when making a call.
     *           Character 'w' can be used to add a 0.5 sec delay.
     *     @type bool $play_ringtone
     *           Optionally play dialtone in the room as an audible indicator for existing participants. The `play_ringtone` option is deprectated but has the same effect.
     *     @type bool $play_dialtone
     *     @type bool $hide_phone_number
     *           By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     *           If true, a random value for identity will be used and numbers will be omitted from attributes.
     *     @type array|\Google\Protobuf\Internal\MapField $headers
     *           These headers are sent as-is and may help identify this call as coming from LiveKit for the other SIP endpoint.
     *     @type int $include_headers
     *           Map SIP headers from 200 OK to sip.h.* participant attributes automatically.
     *           When the names of required headers is known, using headers_to_attributes is strongly recommended.
     *           When mapping 200 OK headers to follow-up request headers with attributes_to_headers map,
     *           lowercase header names should be used, for example: sip.h.x-custom-header.
     *     @type \Google\Protobuf\Duration $ringing_timeout
     *           Max time for the callee to answer the call.
     *     @type \Google\Protobuf\Duration $max_call_duration
     *           Max call duration.
     *     @type bool $krisp_enabled
     *           Enable voice isolation for the callee.
     *     @type int $media_encryption
     *     @type bool $wait_until_answered
     *           Wait for the answer for the call before returning.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\LivekitSip::initOnce();
        parent::__construct($data);
    }

    /**
     * What SIP Trunk should be used to dial the user
     *
     * Generated from protobuf field <code>string sip_trunk_id = 1;</code>
     * @return string
     */
    public function getSipTrunkId()
    {
        return $this->sip_trunk_id;
    }

    /**
     * What SIP Trunk should be used to dial the user
     *
     * Generated from protobuf field <code>string sip_trunk_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSipTrunkId($var)
    {
        GPBUtil::checkString($var, True);
        $this->sip_trunk_id = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.livekit.SIPOutboundConfig trunk = 20;</code>
     * @return \Livekit\SIPOutboundConfig|null
     */
    public function getTrunk()
    {
        return $this->trunk;
    }

    public function hasTrunk()
    {
        return isset($this->trunk);
    }

    public function clearTrunk()
    {
        unset($this->trunk);
    }

    /**
     * Generated from protobuf field <code>.livekit.SIPOutboundConfig trunk = 20;</code>
     * @param \Livekit\SIPOutboundConfig $var
     * @return $this
     */
    public function setTrunk($var)
    {
        GPBUtil::checkMessage($var, \Livekit\SIPOutboundConfig::class);
        $this->trunk = $var;

        return $this;
    }

    /**
     * What number should be dialed via SIP
     *
     * Generated from protobuf field <code>string sip_call_to = 2;</code>
     * @return string
     */
    public function getSipCallTo()
    {
        return $this->sip_call_to;
    }

    /**
     * What number should be dialed via SIP
     *
     * Generated from protobuf field <code>string sip_call_to = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSipCallTo($var)
    {
        GPBUtil::checkString($var, True);
        $this->sip_call_to = $var;

        return $this;
    }

    /**
     * Optional SIP From number to use. If empty, trunk number is used.
     *
     * Generated from protobuf field <code>string sip_number = 15;</code>
     * @return string
     */
    public function getSipNumber()
    {
        return $this->sip_number;
    }

    /**
     * Optional SIP From number to use. If empty, trunk number is used.
     *
     * Generated from protobuf field <code>string sip_number = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setSipNumber($var)
    {
        GPBUtil::checkString($var, True);
        $this->sip_number = $var;

        return $this;
    }

    /**
     * What LiveKit room should this participant be connected too
     *
     * Generated from protobuf field <code>string room_name = 3;</code>
     * @return string
     */
    public function getRoomName()
    {
        return $this->room_name;
    }

    /**
     * What LiveKit room should this participant be connected too
     *
     * Generated from protobuf field <code>string room_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRoomName($var)
    {
        GPBUtil::checkString($var, True);
        $this->room_name = $var;

        return $this;
    }

    /**
     * Optional identity of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_identity = 4;</code>
     * @return string
     */
    public function getParticipantIdentity()
    {
        return $this->participant_identity;
    }

    /**
     * Optional identity of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_identity = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setParticipantIdentity($var)
    {
        GPBUtil::checkString($var, True);
        $this->participant_identity = $var;

        return $this;
    }

    /**
     * Optional name of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_name = 7;</code>
     * @return string
     */
    public function getParticipantName()
    {
        return $this->participant_name;
    }

    /**
     * Optional name of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setParticipantName($var)
    {
        GPBUtil::checkString($var, True);
        $this->participant_name = $var;

        return $this;
    }

    /**
     * Optional user-defined metadata. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>string participant_metadata = 8;</code>
     * @return string
     */
    public function getParticipantMetadata()
    {
        return $this->participant_metadata;
    }

    /**
     * Optional user-defined metadata. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>string participant_metadata = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setParticipantMetadata($var)
    {
        GPBUtil::checkString($var, True);
        $this->participant_metadata = $var;

        return $this;
    }

    /**
     * Optional user-defined attributes. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>map<string, string> participant_attributes = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParticipantAttributes()
    {
        return $this->participant_attributes;
    }

    /**
     * Optional user-defined attributes. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>map<string, string> participant_attributes = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParticipantAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->participant_attributes = $arr;

        return $this;
    }

    /**
     * Optionally send following DTMF digits (extension codes) when making a call.
     * Character 'w' can be used to add a 0.5 sec delay.
     *
     * Generated from protobuf field <code>string dtmf = 5;</code>
     * @return string
     */
    public function getDtmf()
    {
        return $this->dtmf;
    }

    /**
     * Optionally send following DTMF digits (extension codes) when making a call.
     * Character 'w' can be used to add a 0.5 sec delay.
     *
     * Generated from protobuf field <code>string dtmf = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDtmf($var)
    {
        GPBUtil::checkString($var, True);
        $this->dtmf = $var;

        return $this;
    }

    /**
     * Optionally play dialtone in the room as an audible indicator for existing participants. The `play_ringtone` option is deprectated but has the same effect.
     *
     * Generated from protobuf field <code>bool play_ringtone = 6 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getPlayRingtone()
    {
        @trigger_error('play_ringtone is deprecated.', E_USER_DEPRECATED);
        return $this->play_ringtone;
    }

    /**
     * Optionally play dialtone in the room as an audible indicator for existing participants. The `play_ringtone` option is deprectated but has the same effect.
     *
     * Generated from protobuf field <code>bool play_ringtone = 6 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setPlayRingtone($var)
    {
        @trigger_error('play_ringtone is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->play_ringtone = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>bool play_dialtone = 13;</code>
     * @return bool
     */
    public function getPlayDialtone()
    {
        return $this->play_dialtone;
    }

    /**
     * Generated from protobuf field <code>bool play_dialtone = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setPlayDialtone($var)
    {
        GPBUtil::checkBool($var);
        $this->play_dialtone = $var;

        return $this;
    }

    /**
     * By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     * If true, a random value for identity will be used and numbers will be omitted from attributes.
     *
     * Generated from protobuf field <code>bool hide_phone_number = 10;</code>
     * @return bool
     */
    public function getHidePhoneNumber()
    {
        return $this->hide_phone_number;
    }

    /**
     * By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     * If true, a random value for identity will be used and numbers will be omitted from attributes.
     *
     * Generated from protobuf field <code>bool hide_phone_number = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setHidePhoneNumber($var)
    {
        GPBUtil::checkBool($var);
        $this->hide_phone_number = $var;

        return $this;
    }

    /**
     * These headers are sent as-is and may help identify this call as coming from LiveKit for the other SIP endpoint.
     *
     * Generated from protobuf field <code>map<string, string> headers = 16;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * These headers are sent as-is and may help identify this call as coming from LiveKit for the other SIP endpoint.
     *
     * Generated from protobuf field <code>map<string, string> headers = 16;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->headers = $arr;

        return $this;
    }

    /**
     * Map SIP headers from 200 OK to sip.h.* participant attributes automatically.
     * When the names of required headers is known, using headers_to_attributes is strongly recommended.
     * When mapping 200 OK headers to follow-up request headers with attributes_to_headers map,
     * lowercase header names should be used, for example: sip.h.x-custom-header.
     *
     * Generated from protobuf field <code>.livekit.SIPHeaderOptions include_headers = 17;</code>
     * @return int
     */
    public function getIncludeHeaders()
    {
        return $this->include_headers;
    }

    /**
     * Map SIP headers from 200 OK to sip.h.* participant attributes automatically.
     * When the names of required headers is known, using headers_to_attributes is strongly recommended.
     * When mapping 200 OK headers to follow-up request headers with attributes_to_headers map,
     * lowercase header names should be used, for example: sip.h.x-custom-header.
     *
     * Generated from protobuf field <code>.livekit.SIPHeaderOptions include_headers = 17;</code>
     * @param int $var
     * @return $this
     */
    public function setIncludeHeaders($var)
    {
        GPBUtil::checkEnum($var, \Livekit\SIPHeaderOptions::class);
        $this->include_headers = $var;

        return $this;
    }

    /**
     * Max time for the callee to answer the call.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ringing_timeout = 11;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getRingingTimeout()
    {
        return $this->ringing_timeout;
    }

    public function hasRingingTimeout()
    {
        return isset($this->ringing_timeout);
    }

    public function clearRingingTimeout()
    {
        unset($this->ringing_timeout);
    }

    /**
     * Max time for the callee to answer the call.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ringing_timeout = 11;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setRingingTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->ringing_timeout = $var;

        return $this;
    }

    /**
     * Max call duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_call_duration = 12;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMaxCallDuration()
    {
        return $this->max_call_duration;
    }

    public function hasMaxCallDuration()
    {
        return isset($this->max_call_duration);
    }

    public function clearMaxCallDuration()
    {
        unset($this->max_call_duration);
    }

    /**
     * Max call duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_call_duration = 12;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxCallDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->max_call_duration = $var;

        return $this;
    }

    /**
     * Enable voice isolation for the callee.
     *
     * Generated from protobuf field <code>bool krisp_enabled = 14;</code>
     * @return bool
     */
    public function getKrispEnabled()
    {
        return $this->krisp_enabled;
    }

    /**
     * Enable voice isolation for the callee.
     *
     * Generated from protobuf field <code>bool krisp_enabled = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setKrispEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->krisp_enabled = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.livekit.SIPMediaEncryption media_encryption = 18;</code>
     * @return int
     */
    public function getMediaEncryption()
    {
        return $this->media_encryption;
    }

    /**
     * Generated from protobuf field <code>.livekit.SIPMediaEncryption media_encryption = 18;</code>
     * @param int $var
     * @return $this
     */
    public function setMediaEncryption($var)
    {
        GPBUtil::checkEnum($var, \Livekit\SIPMediaEncryption::class);
        $this->media_encryption = $var;

        return $this;
    }

    /**
     * Wait for the answer for the call before returning.
     *
     * Generated from protobuf field <code>bool wait_until_answered = 19;</code>
     * @return bool
     */
    public function getWaitUntilAnswered()
    {
        return $this->wait_until_answered;
    }

    /**
     * Wait for the answer for the call before returning.
     *
     * Generated from protobuf field <code>bool wait_until_answered = 19;</code>
     * @param bool $var
     * @return $this
     */
    public function setWaitUntilAnswered($var)
    {
        GPBUtil::checkBool($var);
        $this->wait_until_answered = $var;

        return $this;
    }

}

